

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__($pageTitle)); ?></h1>
            </div>

            <div class="row">
                <div class="col-12 col-md-12 col-lg-12">
                    <form action="" method="post" enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mr-3">

                                    <?php echo e(__('Php Mail Settings')); ?>


                                    <?php if($general->email_method === 'php'): ?>
                                        <i class="far fa-check-circle text-success ft-40"></i>
                                    <?php else: ?>
                                        <i class="far fa-times-circle text-danger ft-40"></i>
                                    <?php endif; ?>

                                </h5>

                                <?php if($general->email_method != 'php'): ?>
                                    <div>

                                        <button type="submit"
                                            class="btn btn-primary"><?php echo e(__('Update Email Configuration')); ?></button>

                                    </div>
                                <?php endif; ?>


                            </div>
                            <div class="card-body">
                                <div class="row align-items-center">


                                    <input type="hidden" name="email_method" value="php">

                                    <div class="form-group col-md-4">

                                        <label for=""><?php echo e(__('Email Sent From')); ?></label>

                                        <input type="email" name="site_email" class="form-control form_control"
                                            value="<?php echo e(@$general->site_email); ?>">

                                    </div>



                                </div>

                            </div>
                        </div>
                    </form>
                </div>


                <div class="col-12 col-md-12 col-lg-12">
                    <form action="" method="post" enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mr-3">

                                    <?php echo e(__('SMTP Mail Settings')); ?>


                                    <?php if($general->email_method === 'smtp'): ?>
                                        <i class="far fa-check-circle text-success ft-40"></i>
                                    <?php else: ?>
                                        <i class="far fa-times-circle text-danger ft-40"></i>
                                    <?php endif; ?>

                                </h5>

                                <?php if($general->email_method != 'smtp'): ?>
                                    <div>

                                        <button type="submit"
                                            class="btn btn-primary float-right"><?php echo e(__('Update Email Configuration')); ?></button>

                                    </div>
                                <?php endif; ?>

                            </div>
                            <div class="card-body">

                                <div class="row">
                                    <input type="hidden" name="email_method" value="smtp">
                                    <div class="col-md-4 my-3">

                                        <label for=""><?php echo e(__('Email Sent From')); ?></label>

                                        <input type="email" name="site_email" class="form-control form_control"
                                            value="<?php echo e(@$general->site_email); ?>">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for=""><?php echo e(__('SMTP HOST')); ?></label>
                                        <input type="text" name="email_config[smtp_host]" class="form-control"
                                            value="<?php echo e(@$general->email_config->smtp_host); ?>">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for=""><?php echo e(__('SMTP Username')); ?></label>
                                        <input type="text" name="email_config[smtp_username]" class="form-control"
                                            value="<?php echo e(@$general->email_config->smtp_username); ?>">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for=""><?php echo e(__('SMTP Password')); ?></label>
                                        <input type="password" name="email_config[smtp_password]" class="form-control"
                                            value="<?php echo e(@$general->email_config->smtp_password); ?>">

                                    </div>
                                    <div class="col-md-4 my-3">

                                        <label for=""><?php echo e(__('SMTP port')); ?></label>
                                        <input type="text" name="email_config[smtp_port]" class="form-control"
                                            value="<?php echo e(@$general->email_config->smtp_port); ?>">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for=""><?php echo e(__('SMTP Encryption')); ?></label>
                                        <select name="email_config[smtp_encryption]" id="encryption"
                                            class="form-control selectric">
                                            <option value="ssl"
                                                <?php echo e(@$general->email_config->smtp_encryption == 'ssl' ? 'selected' : ''); ?>>
                                                <?php echo e(__('SSL')); ?></option>
                                            <option value="tls"
                                                <?php echo e(@$general->email_config->smtp_encryption == 'tls' ? 'selected' : ''); ?>>
                                                <?php echo e(__('TLS')); ?></option>
                                        </select>

                                        <code class="hint"></code>

                                    </div>

                                </div>




                            </div>
                        </div>

                        <!-- Admin Notification Settings -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h5>
                                    <i class="fas fa-bell text-primary"></i>
                                    <?php echo e(__('Admin Email Notifications')); ?>

                                </h5>
                            </div>
                            <div class="card-body">
                                <?php
                                    $adminSettings = json_decode($general->admin_notifications ?? '{}', true);
                                    $defaultSettings = [
                                        'enabled' => true,
                                        'notifications' => [
                                            'deposits' => true,
                                            'withdrawals' => true,
                                            'investments' => true
                                        ],
                                        'emails' => []
                                    ];
                                    $settings = array_merge($defaultSettings, $adminSettings);
                                ?>

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="admin_notifications_enabled" 
                                                       name="admin_notifications[enabled]" 
                                                       value="1" <?php echo e($settings['enabled'] ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="admin_notifications_enabled">
                                                    <strong><?php echo e(__('Enable Admin Email Notifications')); ?></strong>
                                                </label>
                                            </div>
                                            <small class="text-muted"><?php echo e(__('Receive email notifications for user activities')); ?></small>
                                        </div>
                                    </div>
                                </div>

                                <div class="row" id="notification-settings" style="<?php echo e($settings['enabled'] ? '' : 'display: none;'); ?>">
                                    <div class="col-md-6">
                                        <h6 class="text-primary"><?php echo e(__('Notification Types')); ?></h6>
                                        
                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="notify_deposits" 
                                                       name="admin_notifications[notifications][deposits]" 
                                                       value="1" <?php echo e($settings['notifications']['deposits'] ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="notify_deposits">
                                                    <i class="fas fa-coins text-success"></i> <?php echo e(__('New Deposits')); ?>

                                                </label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="notify_withdrawals" 
                                                       name="admin_notifications[notifications][withdrawals]" 
                                                       value="1" <?php echo e($settings['notifications']['withdrawals'] ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="notify_withdrawals">
                                                    <i class="fas fa-money-bill-wave text-warning"></i> <?php echo e(__('Withdrawal Requests')); ?>

                                                </label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="notify_investments" 
                                                       name="admin_notifications[notifications][investments]" 
                                                       value="1" <?php echo e($settings['notifications']['investments'] ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="notify_investments">
                                                    <i class="fas fa-chart-line text-primary"></i> <?php echo e(__('New Investments')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h6 class="text-primary"><?php echo e(__('Notification Recipients')); ?></h6>
                                        
                                        <div class="form-group">
                                            <label for="admin_emails"><?php echo e(__('Admin Email Addresses')); ?></label>
                                            <textarea class="form-control" id="admin_emails" name="admin_notifications[emails]" 
                                                      rows="4" placeholder="admin@fortisbeaconholdings.com&#10;manager@fortisbeaconholdings.com"><?php echo e(implode("\n", $settings['emails'])); ?></textarea>
                                            <small class="text-muted"><?php echo e(__('Enter one email address per line. Leave empty to use site email.')); ?></small>
                                        </div>

                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i>
                                            <strong><?php echo e(__('Note:')); ?></strong> <?php echo e(__('Notifications will be sent using the modern email templates with professional Fortis Beacon Holdings branding.')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .ft-40 {
            font-size: 20px;
        }
    </style>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        $(function() {
            'use strict'


            $(document).on('change', '#encryption', function() {

                if ($(this).val() == 'ssl') {
                    $('.hint').text("For SSL please add ssl:// before host otherwise it won't work")
                } else {
                    $('.hint').text('')
                }
            })

            // Handle admin notifications toggle
            $(document).on('change', '#admin_notifications_enabled', function() {
                if ($(this).is(':checked')) {
                    $('#notification-settings').slideDown();
                } else {
                    $('#notification-settings').slideUp();
                }
            })
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rozvkomz/public_html/account/core/resources/views/backend/email/config.blade.php ENDPATH**/ ?>