<?php $__env->startSection('content'); ?>

    <?php $__env->startPush('seo'); ?>
        <meta name='description' content="<?php echo e(@$general->seo_description); ?>">
    <?php $__env->stopPush(); ?>


    <section class="auth-section">
        <div class="auth-wrapper">
            <div class="auth-top-part">
                <a href="<?php echo e(route('home')); ?>" class="auth-logo">
                    <img class="img-fluid rounded sm-device-img text-align" src="<?php echo e(getFile('logo', @$general->whitelogo)); ?>"
                        width="100%" alt="pp">
                </a>
                <p class="text-center"><span class="me-2"><?php echo e(__('Login Again')); ?>?</span> <a href="<?php echo e(route('user.login')); ?>" class="btn main-btn btn-sm" ><?php echo e(__('Login')); ?></a></p>
            </div>
            <div class="auth-body-part">
                <div class="auth-form-wrapper">
                    <h3 class="text-center mb-4"><?php echo e(__('Reset Password')); ?></h3>
                    <form action="<?php echo e(route('user.reset.password')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row justify-content-center">
                            <input type="hidden" name="email" value="<?php echo e($session['email']); ?>">
                            <div class="form-group col-md-12">
                                <label for="" class="sp_text_secondary mt-2 mb-2"><?php echo e(__('New Password')); ?></label>
                                <input type="password" name="password" class="form-control" placeholder="Enter new password">
                            </div>
                            <div class="form-group col-md-12">
                                <label for="" class="sp_text_secondary mb-2 mt-2"><?php echo e(__('Confirm Password')); ?></label>
                                <input type="password" name="password_confirmation" class="form-control" placeholder="Confirm password">
                            </div>
                            <?php if(@$general->allow_recaptcha==1): ?>
                                <div class="col-md-12 my-3">
                                    <script src="https://www.google.com/recaptcha/api.js"></script>
                                    <div class="g-recaptcha" data-sitekey="<?php echo e(@$general->recaptcha_key); ?>"
                                        data-callback="verifyCaptcha"></div>
                                    <div id="g-recaptcha-error"></div>
                                </div>
                            <?php endif; ?>
                            <div class="col-md-12">
                                <button type="submit" id="recaptcha"
                                    class="btn main-btn w-100 mt-3"><?php echo e(__('Reset Password')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="auth-footer-part">
                <p class="text-center mb-0">
                    <?php if(@$general->copyright): ?>
                        <?php echo e(__(@$general->copyright)); ?>

                    <?php endif; ?>
                </p>
            </div>
        </div>
        <div class="auth-thumb-area" style="background-image: url('<?php echo e(asset('asset/theme3/images/bg/plan.jpg')); ?>')">
            <div class="auth-thumb">
                <img src="<?php echo e(getFile('frontendlogin', @$general->frontend_login_image)); ?>" alt="image">
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML =
                    "<span class='sp_text_danger'>{{__('Captcha field is required.')</span>";
                return false;
            }
            return true;
        }

        function verifyCaptcha() {
            document.getElementById('g-recaptcha-error').innerHTML = '';
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(template().'layout.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rozvkomz/public_html/account/core/resources/views/theme3/user/auth/reset.blade.php ENDPATH**/ ?>