

<?php $__env->startSection('content'); ?>
    <div class="greeting">
        Hello <?php echo e($username ?? 'Valued Client'); ?>,
    </div>
    
    <div class="content-body">
        <p>Thank you for your recent payment. We're pleased to confirm that your transaction has been successfully processed.</p>
        
        <div class="highlight-box">
            <h3>✅ Payment Confirmed</h3>
            <p>Your investment in <strong><?php echo e($plan ?? 'Premium Plan'); ?></strong> has been successfully activated.</p>
        </div>
        
        <table class="info-table">
            <tr>
                <td>Transaction ID:</td>
                <td><strong><?php echo e($trx ?? 'TXN123456789'); ?></strong></td>
            </tr>
            <tr>
                <td>Investment Plan:</td>
                <td><strong><?php echo e($plan ?? 'Premium Plan'); ?></strong></td>
            </tr>
            <tr>
                <td>Amount Invested:</td>
                <td><strong><?php echo e($amount ?? '0.00'); ?> <?php echo e($currency ?? 'USD'); ?></strong></td>
            </tr>
            <tr>
                <td>Processing Fee:</td>
                <td><?php echo e($charge ?? '0.00'); ?> <?php echo e($currency ?? 'USD'); ?></td>
            </tr>
            <tr>
                <td>Payment Date:</td>
                <td><?php echo e($payment_date ?? date('M d, Y H:i')); ?></td>
            </tr>
            <tr>
                <td>Status:</td>
                <td><strong style="color: #38a169;">Confirmed</strong></td>
            </tr>
        </table>
        
        <p><strong>What happens next?</strong></p>
        <ul style="margin: 20px 0; padding-left: 20px; color: #4a5568;">
            <li>Your investment is now active and generating returns</li>
            <li>You can track your investment performance in your dashboard</li>
            <li>Returns will be credited according to your plan schedule</li>
            <li>You'll receive regular updates on your investment progress</li>
        </ul>
        
        <p>We appreciate your trust in Fortis Beacon Holdings. Our team is committed to maximizing your investment returns while maintaining the highest standards of security and transparency.</p>
    </div>
    
    <div class="btn-container">
        <a href="<?php echo e(config('app.url')); ?>/invest/log" class="btn">View Investment Details</a>
    </div>
    
    <div class="content-body">
        <p style="margin-bottom: 0;">
            Best regards,<br>
            <strong>The Fortis Beacon Holdings Investment Team</strong>
        </p>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('emails.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rozvkomz/public_html/account/core/resources/views/emails/payment-confirmation.blade.php ENDPATH**/ ?>