

<?php $__env->startSection('content'); ?>
    <div class="greeting">
        🎉 Welcome to Fortis Beacon Holdings, <?php echo e($username ?? 'New Client'); ?>!
    </div>
    
    <div class="content-body">
        <p>Congratulations! Your account has been successfully verified and activated. You are now part of the Fortis Beacon Holdings family, where professional investment management meets cutting-edge technology.</p>
        
        <div class="highlight-box">
            <h3>✅ Account Successfully Activated</h3>
            <div class="info-table">
                <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568; width: 40%;">Account Holder:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-weight: 600;"><?php echo e($username ?? 'N/A'); ?></td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Email Address:</td>
                        <td style="padding: 12px 0; color: #2d3748;"><?php echo e($email ?? 'N/A'); ?></td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Registration Date:</td>
                        <td style="padding: 12px 0; color: #2d3748;"><?php echo e($registration_date ?? now()->format('F j, Y')); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Account Status:</td>
                        <td style="padding: 12px 0; color: #38a169; font-weight: 600;">✅ Verified & Active</td>
                    </tr>
                </table>
            </div>
        </div>
        
        <div class="content-body">
            <p><strong>What's Next?</strong></p>
            
            <div style="background-color: #f0fff4; border-left: 4px solid #38a169; padding: 15px; margin: 20px 0;">
                <p style="margin: 0; color: #2f855a;">
                    <strong>🚀 Your Investment Journey Starts Here</strong><br>
                    Your account is now ready for investment activities and portfolio management.
                </p>
            </div>
            
            <ul style="margin: 20px 0; padding-left: 20px; color: #4a5568;">
                <li><strong>Explore Investment Plans:</strong> Browse our diverse portfolio of investment opportunities</li>
                <li><strong>Complete Your Profile:</strong> Add additional details for enhanced security and personalization</li>
                <?php if(isset($kyc_required) && $kyc_required): ?>
                <li><strong>KYC Verification:</strong> Complete your Know Your Customer verification for higher investment limits</li>
                <?php endif; ?>
                <li><strong>Fund Your Account:</strong> Make your first deposit to start investing</li>
                <li><strong>AI-Powered Trading:</strong> Leverage our advanced AI algorithms for optimal returns</li>
                <li><strong>24/7 Support:</strong> Our professional team is here to assist you anytime</li>
            </ul>
            
            <div style="background-color: #fff5f5; border-left: 4px solid #3182ce; padding: 15px; margin: 20px 0;">
                <p style="margin: 0; color: #1a365d;">
                    <strong>💡 Investment Tip:</strong> Start with our beginner-friendly plans to familiarize yourself with our platform before exploring advanced investment strategies.
                </p>
            </div>
            
            <p><strong>Investment Categories Available:</strong></p>
            <ul style="margin: 20px 0; padding-left: 20px; color: #4a5568;">
                <li>🏘️ <strong>Real Estate:</strong> Diversified property investment portfolios</li>
                <li>🌾 <strong>Agriculture:</strong> Sustainable farming and agricultural ventures</li>
                <li>📈 <strong>Portfolio Management:</strong> Professionally managed investment portfolios</li>
                <li>💰 <strong>Overdraft Services:</strong> Flexible financial solutions</li>
            </ul>
        </div>
    </div>
    
    <div class="btn-container">
        <a href="<?php echo e($dashboard_url ?? config('app.url') . '/user/dashboard'); ?>" class="btn">Access Your Dashboard</a>
    </div>
    
    <div class="content-body">
        <div style="background-color: #f7fafc; border-radius: 8px; padding: 20px; margin: 30px 0;">
            <h4 style="color: #1a365d; margin-bottom: 15px;">🛡️ Security & Support</h4>
            <p style="margin-bottom: 10px; color: #4a5568;">
                <strong>Security:</strong> Your account is protected with industry-standard encryption and security measures.
            </p>
            <p style="margin-bottom: 10px; color: #4a5568;">
                <strong>Support:</strong> Need assistance? Contact our support team at 
                <a href="mailto:<?php echo e($support_email ?? 'support@fortisbeaconholdings.com'); ?>" style="color: #3182ce;"><?php echo e($support_email ?? 'support@fortisbeaconholdings.com'); ?></a>
            </p>
            <p style="margin-bottom: 0; color: #4a5568;">
                <strong>Resources:</strong> Visit our <a href="<?php echo e(config('app.url')); ?>/resources" style="color: #3182ce;">Help Center</a> for guides and tutorials.
            </p>
        </div>
        
        <p style="margin-bottom: 0; font-size: 14px; color: #718096;">
            Welcome to professional investment management with Fortis Beacon Holdings.<br>
            <strong>Ready to grow your wealth?</strong> <a href="<?php echo e($dashboard_url ?? config('app.url') . '/user/dashboard'); ?>" style="color: #3182ce;">Start Investing Today</a>
        </p>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('emails.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rozvkomz/public_html/account/core/resources/views/emails/welcome-notification.blade.php ENDPATH**/ ?>