

<?php $__env->startSection('content'); ?>
    <div class="greeting">
        Hello <?php echo e($username ?? 'Valued Client'); ?>,
    </div>
    
    <div class="content-body">
        <p>We hope this message finds you well. We are writing to provide you with an important update regarding your recent withdrawal request.</p>
        
        <?php if(isset($status)): ?>
            <?php if($status === 'approved'): ?>
                <div class="highlight-box">
                    <h3>✅ Withdrawal Approved</h3>
                    <p>Great news! Your withdrawal request has been successfully approved and processed.</p>
                </div>
            <?php elseif($status === 'pending'): ?>
                <div class="highlight-box">
                    <h3>⏳ Withdrawal Under Review</h3>
                    <p>Your withdrawal request is currently being reviewed by our team. We'll notify you once the process is complete.</p>
                </div>
            <?php elseif($status === 'rejected'): ?>
                <div class="highlight-box">
                    <h3>❌ Withdrawal Request Declined</h3>
                    <p>Unfortunately, your withdrawal request could not be processed at this time. Please contact our support team for more information.</p>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        
        <?php if(isset($transaction_details)): ?>
            <table class="info-table">
                <tr>
                    <td>Transaction ID:</td>
                    <td><strong><?php echo e($transaction_details['id'] ?? 'N/A'); ?></strong></td>
                </tr>
                <tr>
                    <td>Amount:</td>
                    <td><strong><?php echo e($transaction_details['amount'] ?? 'N/A'); ?> <?php echo e($transaction_details['currency'] ?? 'USD'); ?></strong></td>
                </tr>
                <tr>
                    <td>Request Date:</td>
                    <td><?php echo e($transaction_details['date'] ?? date('M d, Y')); ?></td>
                </tr>
                <tr>
                    <td>Status:</td>
                    <td><strong><?php echo e(ucfirst($status ?? 'Processing')); ?></strong></td>
                </tr>
                <?php if(isset($transaction_details['processing_time'])): ?>
                <tr>
                    <td>Expected Processing:</td>
                    <td><?php echo e($transaction_details['processing_time']); ?></td>
                </tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>
        
        <p>If you have any questions or concerns about this withdrawal, please don't hesitate to contact our support team. We're here to assist you every step of the way.</p>
        
        <p>Thank you for choosing Fortis Beacon Holdings for your investment needs.</p>
    </div>
    
    <div class="btn-container">
        <a href="<?php echo e(config('app.url')); ?>/dashboard" class="btn">View Account Dashboard</a>
    </div>
    
    <div class="content-body">
        <p style="margin-bottom: 0;">
            Best regards,<br>
            <strong>The Fortis Beacon Holdings Team</strong>
        </p>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('emails.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rozvkomz/public_html/account/core/resources/views/emails/withdrawal-update.blade.php ENDPATH**/ ?>