<?php

use Illuminate\Support\Facades\Route;
use App\Models\GeneralSetting;
use App\Models\User;

Route::get('/diagnostic-check', function() {
    $general = GeneralSetting::first();
    $latestUser = User::orderBy('created_at', 'desc')->first();
    
    return response()->json([
        'email_verification_enabled' => $general->is_email_verification_on ?? 'NULL',
        'smtp_configured' => isset($general->email_config) && isset($general->email_config->smtp_host),
        'latest_user' => [
            'email' => $latestUser->email ?? 'No users',
            'ev_status' => $latestUser->ev ?? 'N/A',
            'created_at' => $latestUser->created_at ?? 'N/A'
        ],
        'mail_driver' => config('mail.driver'),
        'mail_from' => config('mail.from'),
    ]);
})->name('diagnostic.check');
