<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

Route::get('/clear-all-cache-now', function() {
    try {
        Artisan::call('view:clear');
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        Artisan::call('route:clear');
        
        return response()->json([
            'status' => 'success',
            'message' => 'All caches cleared successfully!',
            'cleared' => [
                'views' => 'cleared',
                'cache' => 'cleared',
                'config' => 'cleared',
                'routes' => 'cleared'
            ]
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => $e->getMessage()
        ], 500);
    }
});
