@extends('emails.master')

@section('content')
    <div class="greeting">
        Hello {{ $username ?? 'Valued Client' }},
    </div>
    
    <div class="content-body">
        <p>We hope this message finds you well. We are writing to provide you with an important update regarding your recent withdrawal request.</p>
        
        @if(isset($status))
            @if($status === 'approved')
                <div class="highlight-box">
                    <h3>✅ Withdrawal Approved</h3>
                    <p>Great news! Your withdrawal request has been successfully approved and processed.</p>
                </div>
            @elseif($status === 'pending')
                <div class="highlight-box">
                    <h3>⏳ Withdrawal Under Review</h3>
                    <p>Your withdrawal request is currently being reviewed by our team. We'll notify you once the process is complete.</p>
                </div>
            @elseif($status === 'rejected')
                <div class="highlight-box">
                    <h3>❌ Withdrawal Request Declined</h3>
                    <p>Unfortunately, your withdrawal request could not be processed at this time. Please contact our support team for more information.</p>
                </div>
            @endif
        @endif
        
        @if(isset($transaction_details))
            <table class="info-table">
                <tr>
                    <td>Transaction ID:</td>
                    <td><strong>{{ $transaction_details['id'] ?? 'N/A' }}</strong></td>
                </tr>
                <tr>
                    <td>Amount:</td>
                    <td><strong>{{ $transaction_details['amount'] ?? 'N/A' }} {{ $transaction_details['currency'] ?? 'USD' }}</strong></td>
                </tr>
                <tr>
                    <td>Request Date:</td>
                    <td>{{ $transaction_details['date'] ?? date('M d, Y') }}</td>
                </tr>
                <tr>
                    <td>Status:</td>
                    <td><strong>{{ ucfirst($status ?? 'Processing') }}</strong></td>
                </tr>
                @if(isset($transaction_details['processing_time']))
                <tr>
                    <td>Expected Processing:</td>
                    <td>{{ $transaction_details['processing_time'] }}</td>
                </tr>
                @endif
            </table>
        @endif
        
        <p>If you have any questions or concerns about this withdrawal, please don't hesitate to contact our support team. We're here to assist you every step of the way.</p>
        
        <p>Thank you for choosing Fortis Beacon Holdings for your investment needs.</p>
    </div>
    
    <div class="btn-container">
        <a href="{{ config('app.url') }}/dashboard" class="btn">View Account Dashboard</a>
    </div>
    
    <div class="content-body">
        <p style="margin-bottom: 0;">
            Best regards,<br>
            <strong>The Fortis Beacon Holdings Team</strong>
        </p>
    </div>
@endsection
