@extends('emails.master')

@section('content')
    <div class="greeting">
        Hello {{ $username ?? 'Valued Client' }},
    </div>
    
    <div class="content-body">
        <p>We received a request to reset the password for your Fortis Beacon Holdings account. If you made this request, please use the verification code below to proceed with resetting your password.</p>
        
        <div class="highlight-box">
            <h3>🔐 Password Reset Code</h3>
            <p style="font-size: 24px; font-weight: 700; color: #3182ce; letter-spacing: 2px; text-align: center; margin: 20px 0;">
                {{ $code ?? 'XXXXXX' }}
            </p>
            <p style="text-align: center; font-size: 14px; color: #718096;">
                This code will expire in 15 minutes for security purposes.
            </p>
        </div>
        
        <p><strong>Important Security Information:</strong></p>
        <ul style="margin: 20px 0; padding-left: 20px; color: #4a5568;">
            <li>This code is valid for 15 minutes only</li>
            <li>Never share this code with anyone</li>
            <li>If you didn't request this reset, please ignore this email</li>
            <li>Your password will remain unchanged if you don't use this code</li>
        </ul>
        
        <p>If you didn't request a password reset, you can safely ignore this email. Your account remains secure, and no changes will be made.</p>
        
        <p>For additional security questions or if you need assistance, please contact our support team immediately.</p>
    </div>
    
    <div class="btn-container">
        <a href="{{ config('app.url') }}/password/reset" class="btn">Reset Password Now</a>
    </div>
    
    <div class="content-body">
        <p style="margin-bottom: 0;">
            Best regards,<br>
            <strong>The Fortis Beacon Holdings Security Team</strong>
        </p>
    </div>
@endsection
