<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ $subject ?? 'Fortis Beacon Holdings' }}</title>
    <!--[if mso]>
    <noscript>
        <xml>
            <o:OfficeDocumentSettings>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    </noscript>
    <![endif]-->
    <style>
        /* Reset and Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body, table, td, p, a, li, blockquote {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        
        table, td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        
        img {
            -ms-interpolation-mode: bicubic;
            border: 0;
            outline: none;
            text-decoration: none;
        }
        
        /* Email Client Fixes */
        .ReadMsgBody { width: 100%; }
        .ExternalClass { width: 100%; }
        .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {
            line-height: 100%;
        }
        
        /* Typography */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, -apple-system, BlinkMacSystemFont, sans-serif;
            font-size: 16px;
            line-height: 1.6;
            color: #333333;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
        }
        
        /* Container */
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        
        /* Header */
        .email-header {
            background: linear-gradient(135deg, #1a365d 0%, #2d5a87 100%);
            padding: 40px 30px;
            text-align: center;
        }
        
        .logo {
            font-size: 28px;
            font-weight: 700;
            color: #ffffff;
            text-decoration: none;
            letter-spacing: -0.5px;
            margin-bottom: 8px;
            display: inline-block;
        }
        
        .logo img {
            max-height: 60px;
            width: auto;
            display: block;
            margin: 0 auto;
        }
        
        .tagline {
            color: #fefefe;
            font-size: 14px;
            font-weight: 400;
            margin: 0;
        }
        
        /* Content Area */
        .email-content {
            padding: 50px 40px;
        }
        
        .greeting {
            font-size: 18px;
            font-weight: 600;
            color: #1a365d;
            margin-bottom: 24px;
        }
        
        .content-body {
            font-size: 16px;
            line-height: 1.7;
            color: #4a5568;
            margin-bottom: 30px;
        }
        
        .content-body p {
            margin-bottom: 20px;
        }
        
        .content-body p:last-child {
            margin-bottom: 0;
        }
        
        /* Highlight Box */
        .highlight-box {
            background-color: #f7fafc;
            border-left: 4px solid #3182ce;
            padding: 24px;
            margin: 30px 0;
            border-radius: 0 8px 8px 0;
        }
        
        .highlight-box h3 {
            color: #1a365d;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 12px;
        }
        
        .highlight-box p {
            color: #4a5568;
            margin-bottom: 0;
        }
        
        /* Button */
        .btn-container {
            text-align: center;
            margin: 40px 0;
        }
        
        .btn {
            display: inline-block;
            background: linear-gradient(135deg, #3182ce 0%, #2c5aa0 100%);
            color: #ffffff !important;
            text-decoration: none;
            padding: 16px 32px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(49, 130, 206, 0.3);
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(49, 130, 206, 0.4);
        }
        
        /* Info Table */
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin: 30px 0;
            background-color: #f7fafc;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .info-table td {
            padding: 16px 20px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        .info-table td:first-child {
            font-weight: 600;
            color: #1a365d;
            width: 40%;
        }
        
        .info-table td:last-child {
            color: #4a5568;
        }
        
        .info-table tr:last-child td {
            border-bottom: none;
        }
        
        /* Footer */
        .email-footer {
            background-color: #1a365d;
            padding: 40px 30px;
            text-align: center;
        }
        
        .footer-content {
            color: #e2e8f0;
            font-size: 14px;
            line-height: 1.6;
        }
        
        .footer-content a {
            color: #90cdf4;
            text-decoration: none;
        }
        
        .footer-content a:hover {
            text-decoration: underline;
        }
        
        .social-links {
            margin: 20px 0 0 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 8px;
            color: #90cdf4;
            text-decoration: none;
            font-size: 14px;
        }
        
        .divider {
            height: 1px;
            background-color: #2d5a87;
            margin: 20px 0;
        }
        
        /* Responsive Design */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                margin: 0 !important;
            }
            
            .email-header {
                padding: 30px 20px !important;
            }
            
            .email-content {
                padding: 30px 20px !important;
            }
            
            .email-footer {
                padding: 30px 20px !important;
            }
            
            .logo {
                font-size: 24px !important;
            }
            
            .logo img {
                max-height: 50px !important;
            }
            
            .greeting {
                font-size: 16px !important;
            }
            
            .content-body {
                font-size: 15px !important;
            }
            
            .btn {
                padding: 14px 24px !important;
                font-size: 15px !important;
            }
            
            .highlight-box {
                padding: 20px !important;
                margin: 20px 0 !important;
            }
            
            .info-table td {
                padding: 12px 16px !important;
            }
        }
        
        /* Dark Mode Support */
        @media (prefers-color-scheme: dark) {
            .email-container {
                background-color: #1a202c !important;
            }
            
            .email-content {
                background-color: #1a202c !important;
            }
            
            .content-body {
                color: #e2e8f0 !important;
            }
            
            .highlight-box {
                background-color: #2d3748 !important;
            }
            
            .info-table {
                background-color: #2d3748 !important;
            }
            
            .info-table td {
                border-bottom-color: #4a5568 !important;
            }
        }
    </style>
</head>
<body>
    <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
        <tr>
            <td align="center" style="padding: 20px 0;">
                <div class="email-container">
                    <!-- Header -->
                    <div class="email-header">
                        <a href="https://fortisbeaconholdings.com/" class="logo">
                            <img src="https://fortisbeaconholdings.com/img/logos/logo-2-light.png" alt="Fortis Beacon Holdings" style="max-height: 60px; width: auto; display: block; margin: 0 auto;">
                        </a>
                        <p class="tagline">Professional Investment Management</p>
                    </div>
                    
                    <!-- Content -->
                    <div class="email-content">
                        @yield('content')
                    </div>
                    
                    <!-- Footer -->
                    <div class="email-footer">
                        <div class="footer-content">
                            <p><strong>Fortis Beacon Holdings</strong></p>
                            <p>Professional Investment Management Services</p>
                            
                            <div class="divider"></div>
                            
                            <p>
                                <a href="https://fortisbeaconholdings.com/">Visit Website</a> |
                                <a href="https://fortisbeaconholdings.com/terms">Terms</a> |
                                <a href="https://fortisbeaconholdings.com/privacy">Privacy Policy</a>
                            </p>
                            
                            <div class="social-links">
                                <a href="#">LinkedIn</a>
                                <a href="#">Twitter</a>
                                <a href="#">Facebook</a>
                            </div>
                            
                            <p style="margin-top: 20px; font-size: 12px; color: #a0aec0;">
                                © {{ date('Y') }} Fortis Beacon Holdings. All rights reserved.<br>
                                This email was sent to you because you have an account with us.
                            </p>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
    </table>
</body>
</html>
