@extends('emails.master')

@section('content')
    <div class="greeting">
        💰 New Withdrawal Request
    </div>
    
    <div class="content-body">
        <p>A user has submitted a new withdrawal request that requires your review and approval.</p>
        
        <div class="highlight-box">
            <h3>🏧 Withdrawal Request Details</h3>
            <div class="info-table">
                <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568; width: 40%;">User:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $user_name ?? 'N/A' }} ({{ $user_email ?? 'N/A' }})</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Withdrawal Amount:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-weight: 700; font-size: 18px;">{{ $amount ?? '0.00' }} {{ $currency ?? 'USD' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Withdrawal Method:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $withdrawal_method ?? 'Bank Transfer' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Request ID:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-family: monospace;">{{ $request_id ?? 'N/A' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Request Date:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $date ?? now()->format('Y-m-d H:i:s') }}</td>
                    </tr>
                    @if(isset($user_balance))
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">User Balance:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $user_balance }} {{ $currency ?? 'USD' }}</td>
                    </tr>
                    @endif
                    @if(isset($withdrawal_charge))
                    <tr>
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Processing Fee:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $withdrawal_charge }} {{ $currency ?? 'USD' }}</td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>
        
        <div class="content-body">
            <p><strong>Action Required:</strong> This withdrawal request is pending your approval.</p>
            
            <ul style="margin: 20px 0; padding-left: 20px; color: #4a5568;">
                <li>Verify the user's account balance and eligibility</li>
                <li>Review the withdrawal method and details</li>
                <li>Check for any compliance or security concerns</li>
                <li>Approve or reject the withdrawal request</li>
            </ul>
            
            @if(isset($withdrawal_details))
            <div style="background-color: #f7fafc; padding: 15px; border-radius: 8px; margin: 15px 0;">
                <p style="margin: 0; font-size: 14px; color: #4a5568;">
                    <strong>Withdrawal Details:</strong><br>
                    {{ $withdrawal_details }}
                </p>
            </div>
            @endif
        </div>
    </div>
    
    <div class="btn-container">
        <a href="{{ config('app.url') }}/admin/withdraw/{{ $request_id ?? '' }}" class="btn">Process Withdrawal</a>
    </div>
    
    <div class="content-body">
        <p style="margin-bottom: 0; font-size: 14px; color: #718096;">
            This withdrawal request requires immediate attention.<br>
            <strong>Admin Dashboard:</strong> <a href="{{ config('app.url') }}/admin" style="color: #3182ce;">{{ config('app.url') }}/admin</a>
        </p>
    </div>
@endsection
