@extends('emails.master')

@section('content')
    <div class="greeting">
        📈 New Investment Made
    </div>
    
    <div class="content-body">
        <p>Great news! A user has made a new investment on the Fortis Beacon Holdings platform.</p>
        
        <div class="highlight-box">
            <h3>💼 Investment Details</h3>
            <div class="info-table">
                <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568; width: 40%;">Investor:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $user_name ?? 'N/A' }} ({{ $user_email ?? 'N/A' }})</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Investment Plan:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-weight: 600;">{{ $plan_name ?? 'N/A' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Investment Amount:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-weight: 700; font-size: 18px; color: #38a169;">{{ $amount ?? '0.00' }} {{ $currency ?? 'USD' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Payment Method:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $payment_method ?? 'Unknown' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Transaction ID:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-family: monospace;">{{ $transaction_id ?? 'N/A' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Investment Date:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $date ?? now()->format('Y-m-d H:i:s') }}</td>
                    </tr>
                    @if(isset($expected_return))
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Expected Return:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $expected_return }}%</td>
                    </tr>
                    @endif
                    @if(isset($investment_period))
                    <tr>
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Investment Period:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $investment_period }}</td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>
        
        <div class="content-body">
            <p><strong>Investment Status:</strong> This investment has been successfully processed and is now active.</p>
            
            <div style="background-color: #f0fff4; border-left: 4px solid #38a169; padding: 15px; margin: 20px 0;">
                <p style="margin: 0; color: #2f855a;">
                    <strong>✅ Investment Activated</strong><br>
                    The user's investment is now generating returns according to the selected plan.
                </p>
            </div>
            
            <ul style="margin: 20px 0; padding-left: 20px; color: #4a5568;">
                <li>Investment funds have been successfully allocated</li>
                <li>Return calculations have been initiated</li>
                <li>User has been notified of successful investment</li>
                <li>Investment tracking is now active in the system</li>
            </ul>
            
            @if(isset($referral_bonus))
            <div style="background-color: #fffaf0; border-left: 4px solid #ed8936; padding: 15px; margin: 20px 0;">
                <p style="margin: 0; color: #c05621;">
                    <strong>💰 Referral Bonus:</strong> {{ $referral_bonus }} {{ $currency ?? 'USD' }} commission generated
                </p>
            </div>
            @endif
        </div>
    </div>
    
    <div class="btn-container">
        <a href="{{ config('app.url') }}/admin/users/details/{{ $user_id ?? '' }}" class="btn">View User Details</a>
    </div>
    
    <div class="content-body">
        <p style="margin-bottom: 0; font-size: 14px; color: #718096;">
            This investment has been automatically processed and activated.<br>
            <strong>Investment Reports:</strong> <a href="{{ config('app.url') }}/admin/payment-report" style="color: #3182ce;">View All Investments</a>
        </p>
    </div>
@endsection
