@extends('emails.master')

@section('content')
    <div class="greeting">
        🏦 New Deposit Request
    </div>
    
    <div class="content-body">
        <p>A new deposit has been made on the Fortis Beacon Holdings platform.</p>
        
        <div class="highlight-box">
            <h3>💰 Deposit Details</h3>
            <div class="info-table">
                <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568; width: 40%;">User:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $user_name ?? 'N/A' }} ({{ $user_email ?? 'N/A' }})</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Amount:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-weight: 700; font-size: 18px;">{{ $amount ?? '0.00' }} {{ $currency ?? 'USD' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Payment Method:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $payment_method ?? 'Unknown' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Transaction ID:</td>
                        <td style="padding: 12px 0; color: #2d3748; font-family: monospace;">{{ $transaction_id ?? 'N/A' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #e2e8f0;">
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Date & Time:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $date ?? now()->format('Y-m-d H:i:s') }}</td>
                    </tr>
                    @if(isset($plan_name))
                    <tr>
                        <td style="padding: 12px 0; font-weight: 600; color: #4a5568;">Investment Plan:</td>
                        <td style="padding: 12px 0; color: #2d3748;">{{ $plan_name }}</td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>
        
        <div class="content-body">
            <p><strong>Action Required:</strong> Please review this deposit and take appropriate action in the admin panel.</p>
            
            <ul style="margin: 20px 0; padding-left: 20px; color: #4a5568;">
                <li>Verify the payment details and transaction</li>
                <li>Confirm the deposit amount and method</li>
                <li>Process the deposit approval if everything is correct</li>
                <li>Contact the user if there are any issues</li>
            </ul>
        </div>
    </div>
    
    <div class="btn-container">
        <a href="{{ config('app.url') }}/admin/deposit/payments/{{ $transaction_id ?? '' }}" class="btn">Review Deposit</a>
    </div>
    
    <div class="content-body">
        <p style="margin-bottom: 0; font-size: 14px; color: #718096;">
            This is an automated notification from the Fortis Beacon Holdings admin system.<br>
            <strong>Admin Dashboard:</strong> <a href="{{ config('app.url') }}/admin" style="color: #3182ce;">{{ config('app.url') }}/admin</a>
        </p>
    </div>
@endsection
