@extends('backend.layout.master')
@section('content')

    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>{{ __($pageTitle) }}</h1>
                <div class="section-header-button">
                    <form action="{{ route('admin.email.templates.modern') }}" method="POST" style="display: inline;">
                        @csrf
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-magic"></i> Update to Modern Design
                        </button>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>{{ __('Sl') }}</th>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Subject') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($emailTemplates as $key => $email)
                                    <tr>
                                        <td>{{ $key + $emailTemplates->firstItem() }}</td>
                                        <td>{{ str_replace('_', ' ', $email->name) }}</td>
                                        <td>{{ $email->subject }}</td>
                                        <td>
                                            <a href="{{ route('admin.email.templates.edit', $email) }}"
                                                class="btn btn-sm btn-primary" title="Edit Template">
                                                <i class="fa fa-pen"></i>
                                            </a>
                                            <a href="{{ route('admin.email.templates.preview', $email) }}"
                                                class="btn btn-sm btn-info" title="Preview Template" target="_blank">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __('No Email Template Found') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($emailTemplates->hasPages())
                    <div class="card-footer">
                        {{ $emailTemplates->links('backend.partial.paginate') }}
                    </div>
                @endif
            </div>
        </section>
    </div>
@endsection
