@extends('backend.layout.master')

@section('content')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>{{ __($pageTitle) }}</h1>
            </div>

            <div class="row">
                <div class="col-12 col-md-12 col-lg-12">
                    <form action="" method="post" enctype="multipart/form-data">

                        @csrf
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mr-3">

                                    {{ __('Php Mail Settings') }}

                                    @if ($general->email_method === 'php')
                                        <i class="far fa-check-circle text-success ft-40"></i>
                                    @else
                                        <i class="far fa-times-circle text-danger ft-40"></i>
                                    @endif

                                </h5>

                                @if ($general->email_method != 'php')
                                    <div>

                                        <button type="submit"
                                            class="btn btn-primary">{{ __('Update Email Configuration') }}</button>

                                    </div>
                                @endif


                            </div>
                            <div class="card-body">
                                <div class="row align-items-center">


                                    <input type="hidden" name="email_method" value="php">

                                    <div class="form-group col-md-4">

                                        <label for="">{{ __('Email Sent From') }}</label>

                                        <input type="email" name="site_email" class="form-control form_control"
                                            value="{{ @$general->site_email }}">

                                    </div>



                                </div>

                            </div>
                        </div>
                    </form>
                </div>


                <div class="col-12 col-md-12 col-lg-12">
                    <form action="" method="post" enctype="multipart/form-data">

                        @csrf
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mr-3">

                                    {{ __('SMTP Mail Settings') }}

                                    @if ($general->email_method === 'smtp')
                                        <i class="far fa-check-circle text-success ft-40"></i>
                                    @else
                                        <i class="far fa-times-circle text-danger ft-40"></i>
                                    @endif

                                </h5>

                                @if ($general->email_method != 'smtp')
                                    <div>

                                        <button type="submit"
                                            class="btn btn-primary float-right">{{ __('Update Email Configuration') }}</button>

                                    </div>
                                @endif

                            </div>
                            <div class="card-body">

                                <div class="row">
                                    <input type="hidden" name="email_method" value="smtp">
                                    <div class="col-md-4 my-3">

                                        <label for="">{{ __('Email Sent From') }}</label>

                                        <input type="email" name="site_email" class="form-control form_control"
                                            value="{{ @$general->site_email }}">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for="">{{ __('SMTP HOST') }}</label>
                                        <input type="text" name="email_config[smtp_host]" class="form-control"
                                            value="{{ @$general->email_config->smtp_host }}">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for="">{{ __('SMTP Username') }}</label>
                                        <input type="text" name="email_config[smtp_username]" class="form-control"
                                            value="{{ @$general->email_config->smtp_username }}">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for="">{{ __('SMTP Password') }}</label>
                                        <input type="password" name="email_config[smtp_password]" class="form-control"
                                            value="{{ @$general->email_config->smtp_password }}">

                                    </div>
                                    <div class="col-md-4 my-3">

                                        <label for="">{{ __('SMTP port') }}</label>
                                        <input type="text" name="email_config[smtp_port]" class="form-control"
                                            value="{{ @$general->email_config->smtp_port }}">

                                    </div>

                                    <div class="col-md-4 my-3">

                                        <label for="">{{ __('SMTP Encryption') }}</label>
                                        <select name="email_config[smtp_encryption]" id="encryption"
                                            class="form-control selectric">
                                            <option value="ssl"
                                                {{ @$general->email_config->smtp_encryption == 'ssl' ? 'selected' : '' }}>
                                                {{ __('SSL') }}</option>
                                            <option value="tls"
                                                {{ @$general->email_config->smtp_encryption == 'tls' ? 'selected' : '' }}>
                                                {{ __('TLS') }}</option>
                                        </select>

                                        <code class="hint"></code>

                                    </div>

                                </div>




                            </div>
                        </div>

                        <!-- Admin Notification Settings -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h5>
                                    <i class="fas fa-bell text-primary"></i>
                                    {{ __('Admin Email Notifications') }}
                                </h5>
                            </div>
                            <div class="card-body">
                                @php
                                    $adminSettings = json_decode($general->admin_notifications ?? '{}', true);
                                    $defaultSettings = [
                                        'enabled' => true,
                                        'notifications' => [
                                            'deposits' => true,
                                            'withdrawals' => true,
                                            'investments' => true
                                        ],
                                        'emails' => []
                                    ];
                                    $settings = array_merge($defaultSettings, $adminSettings);
                                @endphp

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="admin_notifications_enabled" 
                                                       name="admin_notifications[enabled]" 
                                                       value="1" {{ $settings['enabled'] ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="admin_notifications_enabled">
                                                    <strong>{{ __('Enable Admin Email Notifications') }}</strong>
                                                </label>
                                            </div>
                                            <small class="text-muted">{{ __('Receive email notifications for user activities') }}</small>
                                        </div>
                                    </div>
                                </div>

                                <div class="row" id="notification-settings" style="{{ $settings['enabled'] ? '' : 'display: none;' }}">
                                    <div class="col-md-6">
                                        <h6 class="text-primary">{{ __('Notification Types') }}</h6>
                                        
                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="notify_deposits" 
                                                       name="admin_notifications[notifications][deposits]" 
                                                       value="1" {{ $settings['notifications']['deposits'] ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="notify_deposits">
                                                    <i class="fas fa-coins text-success"></i> {{ __('New Deposits') }}
                                                </label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="notify_withdrawals" 
                                                       name="admin_notifications[notifications][withdrawals]" 
                                                       value="1" {{ $settings['notifications']['withdrawals'] ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="notify_withdrawals">
                                                    <i class="fas fa-money-bill-wave text-warning"></i> {{ __('Withdrawal Requests') }}
                                                </label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" 
                                                       id="notify_investments" 
                                                       name="admin_notifications[notifications][investments]" 
                                                       value="1" {{ $settings['notifications']['investments'] ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="notify_investments">
                                                    <i class="fas fa-chart-line text-primary"></i> {{ __('New Investments') }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h6 class="text-primary">{{ __('Notification Recipients') }}</h6>
                                        
                                        <div class="form-group">
                                            <label for="admin_emails">{{ __('Admin Email Addresses') }}</label>
                                            <textarea class="form-control" id="admin_emails" name="admin_notifications[emails]" 
                                                      rows="4" placeholder="admin@fortisbeaconholdings.com&#10;manager@fortisbeaconholdings.com">{{ implode("\n", $settings['emails']) }}</textarea>
                                            <small class="text-muted">{{ __('Enter one email address per line. Leave empty to use site email.') }}</small>
                                        </div>

                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i>
                                            <strong>{{ __('Note:') }}</strong> {{ __('Notifications will be sent using the modern email templates with professional Fortis Beacon Holdings branding.') }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </section>
    </div>
@endsection

@push('style')
    <style>
        .ft-40 {
            font-size: 20px;
        }
    </style>
@endpush


@push('script')
    <script>
        $(function() {
            'use strict'


            $(document).on('change', '#encryption', function() {

                if ($(this).val() == 'ssl') {
                    $('.hint').text("For SSL please add ssl:// before host otherwise it won't work")
                } else {
                    $('.hint').text('')
                }
            })

            // Handle admin notifications toggle
            $(document).on('change', '#admin_notifications_enabled', function() {
                if ($(this).is(':checked')) {
                    $('#notification-settings').slideDown();
                } else {
                    $('#notification-settings').slideUp();
                }
            })
        })
    </script>
@endpush
