<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmailTemplate;

class AdminEmailTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $templates = [
            [
                'name' => 'ADMIN_NEW_DEPOSIT',
                'subject' => 'New Deposit Request - Action Required',
                'template' => '<p><b>Hi Administrator,</b></p><p><b>A new deposit has been made on the platform.</b></p><p><b>User: {user_name} ({user_email})</b></p><p><b>Amount: {amount} {currency}</b></p><p><b>Payment Method: {payment_method}</b></p><p><b>Transaction ID: {transaction_id}</b></p><p><b>Date: {date}</b></p><p><b><br></b></p><p>Please review this deposit in the admin panel.</p><p><b><br></b></p><p>Thanks,<br>Fortis Beacon Holdings System</p>',
                'meaning' => json_encode([
                    'user_name' => 'User Name',
                    'user_email' => 'User Email',
                    'amount' => 'Deposit Amount',
                    'currency' => 'Currency',
                    'payment_method' => 'Payment Method',
                    'transaction_id' => 'Transaction ID',
                    'date' => 'Date and Time'
                ])
            ],
            [
                'name' => 'ADMIN_NEW_WITHDRAWAL',
                'subject' => 'New Withdrawal Request - Approval Required',
                'template' => '<p><b>Hi Administrator,</b></p><p><b>A user has requested a withdrawal.</b></p><p><b>User: {user_name} ({user_email})</b></p><p><b>Amount: {amount} {currency}</b></p><p><b>Withdrawal Method: {withdrawal_method}</b></p><p><b>Request ID: {request_id}</b></p><p><b>Date: {date}</b></p><p><b><br></b></p><p>This withdrawal request requires your immediate attention.</p><p><b><br></b></p><p>Thanks,<br>Fortis Beacon Holdings System</p>',
                'meaning' => json_encode([
                    'user_name' => 'User Name',
                    'user_email' => 'User Email',
                    'amount' => 'Withdrawal Amount',
                    'currency' => 'Currency',
                    'withdrawal_method' => 'Withdrawal Method',
                    'request_id' => 'Request ID',
                    'date' => 'Date and Time'
                ])
            ],
            [
                'name' => 'ADMIN_NEW_INVESTMENT',
                'subject' => 'New Investment Made - Portfolio Update',
                'template' => '<p><b>Hi Administrator,</b></p><p><b>A user has made a new investment.</b></p><p><b>User: {user_name} ({user_email})</b></p><p><b>Plan: {plan_name}</b></p><p><b>Amount: {amount} {currency}</b></p><p><b>Payment Method: {payment_method}</b></p><p><b>Transaction ID: {transaction_id}</b></p><p><b>Date: {date}</b></p><p><b><br></b></p><p>The investment has been successfully processed and activated.</p><p><b><br></b></p><p>Thanks,<br>Fortis Beacon Holdings System</p>',
                'meaning' => json_encode([
                    'user_name' => 'User Name',
                    'user_email' => 'User Email',
                    'plan_name' => 'Investment Plan',
                    'amount' => 'Investment Amount',
                    'currency' => 'Currency',
                    'payment_method' => 'Payment Method',
                    'transaction_id' => 'Transaction ID',
                    'date' => 'Date and Time'
                ])
            ]
        ];

        foreach ($templates as $template) {
            EmailTemplate::updateOrCreate(
                ['name' => $template['name']],
                $template
            );
        }
    }
}
