<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAdminNotificationsToGeneralSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->json('admin_notifications')->nullable()->after('site_email');
        });
        
        // Set default admin notification settings
        DB::table('general_settings')->update([
            'admin_notifications' => json_encode([
                'enabled' => true,
                'notifications' => [
                    'deposits' => true,
                    'withdrawals' => true,
                    'investments' => true
                ],
                'emails' => []
            ])
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn('admin_notifications');
        });
    }
}
