<?php

namespace App\Http\Middleware;


use App\Models\GeneralSetting;
use Closure;
use Pnlinh\InfobipSms\Facades\InfobipSms;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class isEmailVerified
{

    public function handle($request, Closure $next)
    {

        $general = GeneralSetting::first();

        $user = auth()->user();


        if ($general->is_email_verification_on && !$user->ev) {

            $randomNumber = rand(0, 999999);

            $user->verification_code = $randomNumber;
            $user->save();

            // Build email message with inline HTML
            $username = $user->fname . ' ' . $user->lname;
            $verificationUrl = config('app.url') . '/user/authentication-verify';
            
            $emailBody = $this->buildVerificationEmail($username, $randomNumber, $verificationUrl);

            $data = [
                'email' => $user->email,
                'subject' => 'Welcome to Fortis Beacon Holdings - Email Verification',
                'message' => $emailBody
            ];

            if ($general->email_method == 'php') {
                $headers = "From: $general->sitename <$general->site_email> \r\n";
                $headers .= "Reply-To: $general->sitename <$general->site_email> \r\n";
                $headers .= "MIME-Version: 1.0\r\n";
                $headers .= "Content-Type: text/html; charset=utf-8\r\n";
                @mail($data['email'], $data['subject'], $data['message'], $headers);
            } else {
                $mail = new PHPMailer(true);

                try {
                    $mail->isSMTP();
                    $mail->Host       = $general->email_config->smtp_host;
                    $mail->SMTPAuth   = true;
                    $mail->Username   = $general->email_config->smtp_username;
                    $mail->Password   = $general->email_config->smtp_password;
                    if ($general->email_config->smtp_encryption == 'ssl') {
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                    } else {
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                    }
                    $mail->Port       = $general->email_config->smtp_port;
                    $mail->CharSet = 'UTF-8';
                    $mail->setFrom($general->site_email, $general->sitename);
                    $mail->addAddress($data['email']);
                    $mail->addReplyTo($general->site_email, $general->sitename);
                    $mail->isHTML(true);
                    $mail->Subject = $data['subject'];
                    $mail->Body    = $data['message'];
                    $mail->send();
                } catch (Exception $e) {
                    \Log::error('Email verification send failed', [
                        'user_id' => $user->id,
                        'error' => $e->getMessage()
                    ]);
                }
            }

            return redirect()->route('user.authentication.verify');
        }elseif ($general->is_sms_verification_on && !$user->sv) {
            $calling_code = rtrim(file_get_contents('https://ipapi.co/103.100.232.0/country_calling_code/'), "0");

            $randomNumber = rand(0, 999999);


            $user->sms_verification_code = $randomNumber;
            $user->save();

            try {
                $basic  = new \Nexmo\Client\Credentials\Basic(env("NEXMO_KEY"), env("NEXMO_SECRET"));
                $client = new \Nexmo\Client($basic);
    
                $receiverNumber = $calling_code . $user->phone;
                $message = 'Your SMS Verification Code is :' . $randomNumber;
    
                $message = $client->message()->send([
                    'to' => $receiverNumber,
                    'from' => $general->sitename,
                    'text' => $message
                ]);
            } catch (\Throwable $th) {
                $notify[] = ['error','Sms Provider Credentials Not Found'];

                return redirect()->back()->withNotify($notify);
            }

           
  
            return redirect()->route('user.authentication.verify');
        }


        return $next($request);
    }

    /**
     * Build professional verification email HTML
     */
    private function buildVerificationEmail($username, $code, $verificationUrl)
    {
        return '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background-color: #f4f4f4; }
        .container { max-width: 600px; margin: 20px auto; background: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .header { background: #1a365d; padding: 30px; text-align: center; }
        .header img { max-height: 60px; }
        .content { padding: 40px 30px; }
        .greeting { font-size: 24px; font-weight: bold; color: #1a365d; margin-bottom: 20px; }
        .highlight-box { background: #f0f9ff; border-left: 4px solid #3182ce; padding: 20px; margin: 20px 0; border-radius: 4px; }
        .code { font-size: 32px; font-weight: 700; color: #3182ce; letter-spacing: 3px; text-align: center; margin: 20px 0; font-family: monospace; }
        .button { display: inline-block; padding: 12px 30px; background: #3182ce; color: #ffffff !important; text-decoration: none; border-radius: 4px; margin: 20px 0; }
        .info-box { background: #f0fff4; border-left: 4px solid #38a169; padding: 15px; margin: 20px 0; }
        .warning-box { background: #fff5f5; border-left: 4px solid #e53e3e; padding: 15px; margin: 20px 0; }
        .footer { background: #f7fafc; padding: 20px; text-align: center; font-size: 12px; color: #718096; }
        ul { padding-left: 20px; color: #4a5568; }
        li { margin: 10px 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1 style="color: #ffffff; margin: 0;">Fortis Beacon Holdings</h1>
            <p style="color: #cbd5e0; margin: 5px 0 0 0;">Professional Investment Management</p>
        </div>
        
        <div class="content">
            <div class="greeting">Welcome, ' . htmlspecialchars($username) . '!🎉</div>
            
            <p>Congratulations on taking the first step towards professional investment management! We\'re thrilled to have you join the Fortis Beacon Holdings family.</p>
            
            <p>To ensure the security of your account and complete your registration, please verify your email address using the verification code below:</p>
            
            <div class="highlight-box">
                <h3 style="margin-top: 0;">📧 Your Email Verification Code</h3>
                <div class="code">' . htmlspecialchars($code) . '</div>
                <p style="text-align: center; font-size: 14px; color: #718096;">Enter this code on the verification page to activate your account.</p>
            </div>
            
            <div class="info-box">
                <p style="margin: 0; color: #2f855a;">
                    <strong>✅ What Happens After Verification?</strong><br>
                    You\'ll gain instant access to our AI-powered investment platform and can start building your wealth.
                </p>
            </div>
            
            <p><strong>Why Verify Your Email?</strong></p>
            <ul>
                <li><strong>Security:</strong> Protect your account with verified contact information</li>
                <li><strong>Notifications:</strong> Receive important updates about your investments and returns</li>
                <li><strong>Recovery:</strong> Enable secure password recovery options</li>
                <li><strong>Full Access:</strong> Unlock all platform features and investment opportunities</li>
            </ul>
            
            <p><strong>What\'s Waiting for You:</strong></p>
            <ul>
                <li>🏘️ <strong>Real Estate Investments:</strong> Diversified property portfolios with stable returns</li>
                <li>🌾 <strong>Agricultural Ventures:</strong> Sustainable farming opportunities</li>
                <li>📈 <strong>Portfolio Management:</strong> AI-driven investment strategies</li>
                <li>💰 <strong>Flexible Solutions:</strong> Overdraft and financial services</li>
                <li>🤖 <strong>AI Integration:</strong> Advanced algorithms for optimal performance</li>
            </ul>
            
            <div class="warning-box">
                <p style="margin: 0; color: #c53030;">
                    <strong>⏰ Important:</strong> This verification code will expire in 24 hours. If you didn\'t create an account with us, please ignore this email or contact our support team.
                </p>
            </div>
            
            <p>Once verified, you\'ll have immediate access to explore our investment plans, fund your account, and start your journey toward financial growth with professional-grade tools and support.</p>
            
            <center>
                <a href="' . htmlspecialchars($verificationUrl) . '" class="button">Verify Email Address Now</a>
            </center>
            
            <p style="margin-top: 30px;">
                Welcome aboard,<br>
                <strong>The Fortis Beacon Holdings Team</strong><br>
                <em style="color: #718096; font-size: 14px;">Professional Investment Management</em>
            </p>
        </div>
        
        <div class="footer">
            <p>© 2025 Fortis Beacon Holdings. All rights reserved.</p>
            <p>Need help? Contact us at <a href="mailto:support@fortisbeaconholdings.com" style="color: #3182ce;">support@fortisbeaconholdings.com</a></p>
        </div>
    </div>
</body>
</html>';
    }
}
