<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Helpers\EmailHelper;

class UpdateEmailTemplates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:update-templates';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update email templates to modern responsive design';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Updating email templates to modern design...');

        try {
            EmailHelper::updateEmailTemplates();
            $this->info('✅ Email templates updated successfully!');
            
            $this->line('');
            $this->line('Modern email templates now include:');
            $this->line('• Responsive design for all devices');
            $this->line('• Professional Fortis Beacon Holdings branding');
            $this->line('• Improved visual hierarchy and typography');
            $this->line('• Dark mode support');
            $this->line('• Enhanced security and accessibility features');
            
            return Command::SUCCESS;
        } catch (\Exception $e) {
            $this->error('❌ Failed to update email templates: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
